<h2>Why is this an issue?</h2>
<p>When the execution is not explicitly terminated at the end of a switch case, it continues to execute the statements of the following case. While
this is sometimes intentional, it often is a mistake which leads to unexpected behavior.</p>
<h3>Noncompliant code example</h3>

```php
switch ($myVariable) {
  case 1:
    foo();
    break;
  case 2:  // Both 'doSomething()' and 'doSomethingElse()' will be executed. Is it on purpose ?
    do_something();
  default:
    do_something_else();
   break;
}
```
<h3>Compliant solution</h3>

```php
switch ($myVariable) {
  case 1:
    foo();
    break;
  case 2:
    do_something();
    break;
  default:
    do_something_else();
   break;
}
```
<h3>Exceptions</h3>
<p>This rule is relaxed in following cases:</p>

```php
switch ($myVariable) {
  case 0:                  // Empty case used to specify the same behavior for a group of cases.
  case 1:
    do_something();
    break;
  case 2:                  // Use of continue statement
    continue;
  case 3:                  // Case includes a jump statement (exit, return, break &etc)
    exit(0);
  case 4:
    echo 'Second case, which falls through';
    // no break        <- comment is used when fall-through is intentional in a non-empty case body
  default:                 // For the last case, use of break statement is optional
    doSomethingElse();
}
```
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/484">CWE-484 - Omitted Break Statement in Switch</a> </li>
</ul>