<p>Once control flow has been moved out of the current code block, any subsequent statements become effectively unreachable.</p>
<h2>Why is this an issue?</h2>
<p>Some statements (<code>return</code>, <code>break</code>, <code>continue</code>, <code>goto</code>, <code>switch</code>) and <code>throw</code>
expressions move control flow out of the current code block. So any unlabeled statements that come after such a jump are unreachable, and either this
dead code should be removed, or the logic should be corrected.</p>
<h3>Noncompliant code example</h3>

```php
function fun($a) {
  $i = 10;
  return $i + $a;
  $i++;             // dead code
}
```
<h3>Compliant solution</h3>

```php
function fun($a) {
  $i = 10;
  return $i + $a;
}
```
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/561">CWE-561 - Dead Code</a> </li>
</ul>