<h2>Why is this an issue?</h2>
<p>There’s no point in having a PHPUnit test case without any test methods. Similarly, you shouldn’t have a file in the tests directory which extends
PHPUnit\Framework\TestCase but no tests in the file. Doing either of these things may lead someone to think that uncovered classes have been tested.
Add some test method or make the class abstract if it is used by a real test case class.</p>
<h3>Noncompliant code example</h3>

```php
use PHPUnit\Framework\TestCase;

class MyTest extends TestCase {

  protected function setUp() {
    doSomethind();
  }


  private function doSomethind() {
    //...
  }
}
```
<h3>Compliant solution</h3>

```php
use PHPUnit\Framework\TestCase;

class MyTest extends TestCase {

  public function testBehaviour() {
   //...
  }

  //...
} 

// or

abstract class MyAbstractTest extends TestCase {

 protected function setUp() {
   doSomethind();
 }


 private function doSomethind() {
   //...
 }
}
```