<h2>Why is this an issue?</h2>
<p>Dependency injection is a software design pattern in which one or more dependencies (or services) are injected, or passed by reference, into a
dependent object (or client) and are made part of the client’s state. The pattern separates the creation of a client’s dependencies from its own
behavior, which allows program designs to be loosely coupled and to follow the dependency inversion and single responsibility principles.</p>
<h3>Noncompliant code example</h3>

```php
class SomeClass {

  public function __construct() {
    $this->object = new SomeOtherClass();  // Noncompliant
  }
}
```
<h3>Compliant solution</h3>

```php
class SomeClass {

  public function __construct(SomeOtherClass $object) {
    $this->object = $object;
  }
}
```