<p>This rule is deprecated, and will eventually be removed.</p>
<h2>Why is this an issue?</h2>
<p>Cookies without fixed lifetimes or expiration dates are known as non-persistent, or "session" cookies, meaning they last only as long as the
browser session, and poof away when the browser closes. Cookies with expiration dates, "persistent" cookies, are stored/persisted until those
dates.</p>
<p>Non-persistent cookies should be used for the management of logged-in sessions on web sites. To make a cookie non-persistent, simply omit the
<code>expires</code> attribute.</p>
<p>This rule raises an issue when <code>expires</code> is set for a session cookie, either programmatically or via configuration, such as
<code>session.cookie_lifetime</code>.</p>
<h2>Resources</h2>
<ul>
  <li> OWASP - <a href="https://owasp.org/www-project-top-ten/2017/A7_2017-Cross-Site_Scripting_(XSS)">Top 10 2017 Category A7 - Cross-Site Scripting
  (XSS)</a> </li>
  <li> <a href="https://cheatsheetseries.owasp.org/cheatsheets/Session_Management_Cheat_Sheet.html#expire-and-max-age-attributes">OWASP, Session
  Management Cheat Sheet</a> - Expire and Max-Age Attributes </li>
  <li> Derived from FindSecBugs rule <a href="https://find-sec-bugs.github.io/bugs.htm#COOKIE_PERSISTENT">COOKIE_PERSISTENT</a> </li>
</ul>