<h2>Why is this an issue?</h2>
<p>In regular expressions the boundaries <code>^</code> and <code>\A</code> can only match at the beginning of the input (or, in case of
<code>^</code> in combination with the <code>MULTILINE</code> flag, the beginning of the line) and <code>$</code>, <code>\Z</code> and <code>\z</code>
only at the end.</p>
<p>These patterns can be misused, by accidentally switching <code>^</code> and <code>$</code> for example, to create a pattern that can never
match.</p>
<h3>Noncompliant code example</h3>

```php
// This can never match because $ and ^ have been switched around
preg_match("/$[a-z]+^/", $str); // Noncompliant
```
<h3>Compliant solution</h3>

```php
preg_match("/^[a-z]+$/", $str);
```