<h2>Why is this an issue?</h2>
<p>Alternation is used to match a single regular expression out of several possible regular expressions. If one of the alternatives is empty it would
match any input, which is most probably a mistake.</p>
<h3>Noncompliant code example</h3>

```php
preg_match("/Jack|Peter|/", "John"); // Noncompliant - returns 1
preg_match("/Jack||Peter/", "John"); // Noncompliant - returns 1
```
<h3>Compliant solution</h3>

```php
preg_match("/Jack|Peter/", "John"); // returns 0
```
<h3>Exceptions</h3>
<p>One could use an empty alternation to make a regular expression group optional. Note that the empty alternation should be the first or the last
within the group, or else the rule will still report.</p>

```php
preg_match("/mandatory(|-optional)/", "mandatory"); // returns 1
preg_match("/mandatory(-optional|)/", "mandatory-optional"); // returns 1
```
<p>However, if there is a quantifier after the group the issue will be reported as using both <code>|</code> and quantifier is redundant.</p>

```php
preg_match("/mandatory(-optional|)?/", "mandatory-optional"); // Noncompliant - using both `|` inside the group and `?` for the group.
```