<h2>Why is this an issue?</h2>
<p>In JavaScript, labels are identifiers that allow you to name blocks of code, such as loops and conditional statements. They are used in conjunction
with statements like <code>break</code> and <code>continue</code> to control the flow of execution within nested loops and conditionals.</p>
<p>It’s worth noting that labels are not widely used in modern JavaScript programming because they can lead to complex and hard-to-maintain code. In
most cases, there are better alternatives to achieve the desired control flow without resorting to labels.</p>

```ts
myLabel: {
  let x = doSomething();
  if (x > 0) {
    break myLabel;
  }
  doSomethingElse();
}
```
<p>If you find yourself using labels, you should reevaluate your code structure and explore other options for better code clarity and
maintainability.</p>

```ts
let x = doSomething();
if (x <= 0) {
  doSomethingElse();
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/label">label</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/break"><code>break</code></a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/continue"><code>continue</code></a> </li>
</ul>