<h2>Why is this an issue?</h2>
<p>Unnecessary imports refer to importing modules, libraries, or dependencies that are not used or referenced anywhere in the code. These imports do
not contribute to the functionality of the application and only add extra weight to the JavaScript bundle, leading to potential performance and
maintainability issues.</p>

```ts
import A from 'a'; // Noncompliant: The imported symbol 'A' isn't used
import { B1 } from 'b';

console.log(B1);
```
<p>To mitigate the problems associated with unnecessary imports, you should regularly review and remove any imports that are not being used. Modern
JavaScript build tools and bundlers often provide features like tree shaking, which eliminates unused code during the bundling process, resulting in a
more optimized bundle size.</p>

```ts
import { B1 } from 'b';

console.log(B1);
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/import"><code>import</code></a> </li>
</ul>
<h3>Related rules</h3>
<ul>
  <li> <a href='checks/checks/?languages=JAVASCRIPT&tools=SONAR_LINT&rule=javascript:S1481'>javascript:S1481</a> - Unused local variables and functions should be removed </li>
</ul>