<h2>Why is this an issue?</h2>
<p>The requirement for a final <code>default</code> clause is defensive programming. The clause should either take appropriate action, or contain a
suitable comment as to why no action is taken.</p>
<h3>Noncompliant code example</h3>

```ts
switch (param) {  //missing default clause
  case 0:
    doSomething();
    break;
  case 1:
    doSomethingElse();
    break;
}

switch (param) {
  default: // default clause should be the last one
    error();
    break;
  case 0:
    doSomething();
    break;
  case 1:
    doSomethingElse();
    break;
}
```
<h3>Compliant solution</h3>

```ts
switch (param) {
  case 0:
    doSomething();
    break;
  case 1:
    doSomethingElse();
    break;
  default:
    error();
    break;
}
```
<h3>Exceptions</h3>
<p>The rule ignores <code>switch</code> statements where the discriminant is a TypeScript union and there is a <code>case</code> branch for each
constituent.</p>

```ts
type Season = 'Spring' | 'Summer' | 'Fall' | 'Winter';
let season: Season;
switch (season) {
  case 'Spring':
    wakeUp();
    break;
  case 'Summer':
    getOut();
    break;
  case 'Fall':
    saveFood();
    break;
  case 'Winter':
    sleep();
    break;
}
```
<p>The same applies for TypeScript enums.</p>

```ts
enum Direction {
  Up,
  Down
}

let dir: Direction;
switch (dir) {
  case Direction.Up:
    getUp();
    break;
  case Direction.Down:
    getDown();
    break;
}
```
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/478">CWE-478 - Missing Default Case in Switch Statement</a> </li>
</ul>