<h2>Why is this an issue?</h2>
<p>Nested control flow statements such as <code>if</code>, <code>for</code>, <code>while</code>, <code>switch</code>, and <code>try</code> are often
key ingredients in creating what’s known as "Spaghetti code". This code smell can make your program difficult to understand and maintain.</p>
<p>When numerous control structures are placed inside one another, the code becomes a tangled, complex web. This significantly reduces the code’s
readability and maintainability, and it also complicates the testing process.</p>
<h2>How to fix it</h2>
<h3>Code examples</h3>
<p>The following example demonstrates the behavior of the rule with the default threshold of 3 levels of nesting and one of the potential ways to fix
the code smell by introducing guard clauses:</p>
<h4>Noncompliant code example</h4>

```ts
if (condition1) {                  // Compliant - depth = 1
  /* ... */
  if (condition2) {                // Compliant - depth = 2
    /* ... */
    for (let i = 0; i < 10; i++) {  // Compliant - depth = 3
      /* ... */
      if (condition4) {            // Noncompliant - depth = 4, which exceeds the limit
        if (condition5) {          // Depth = 5, exceeding the limit, but issues are only reported on depth = 4
          /* ... */
        }
        return;
      }
    }
  }
}
```
<h4>Compliant solution</h4>

```ts
if (!condition1) {
  return;
}
/* ... */
if (!condition2) {
  return;
}
for (let i = 0; i < 10; i++) {
  /* ... */
  if (condition4) {
    if (condition5) {
      /* ... */
    }
    return;
  }
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://en.wikipedia.org/wiki/Guard_(computer_science)">Guard clauses in programming</a> - one of the approaches to reducing the depth
  of nesting </li>
</ul>