<h2>Why is this an issue?</h2>
<p>In JavaScript, <code>arguments</code> is a built-in array-like object automatically available within the scope of all non-arrow functions. It
allows you to access the arguments the function was called with, even if the number of arguments passed during the function call does not match the
number declared in the function signature. <code>arguments</code> has entries for each argument, with the first entry’s index at <code>0</code>.</p>
<p>The arguments object has two deprecated properties called <code>arguments.caller</code> and <code>arguments.callee</code>, which were used to refer
to functions involved in the function invocation chain:</p>
<ul>
  <li> The <code>arguments.callee</code> property contains the currently executing function that the arguments belong to. </li>
  <li> The <code>arguments.caller</code> property returns the function that invoked the currently executing function. It was replaced by
  <code>Function.prototype.caller</code>, which provides the same functionality. </li>
</ul>
<p>Both <code>arguments.caller</code> and <code>arguments.callee</code> are non-standard, deprecated, and leak stack information, which poses security
risks and severely limits the possibility of optimizations.</p>
<p>Accessing <code>arguments.callee</code>, <code>Function.prototype.caller</code> and <code>Function.prototype.arguments</code> in strict mode will
throw a <code>TypeError</code>.</p>

```ts
function whoCalled() {
   if (arguments.caller == null)   //Noncompliant
      console.log('I was called from the global scope.');
   else
      console.log(arguments.caller + ' called me!');  // Noncompliant

  console.log(whoCalled.caller);  // Noncompliant
  console.log(whoCalled.arguments);  // Noncompliant
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/arguments">The arguments object</a> </li>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/arguments/callee#description">arguments.callee</a> </li>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/caller">Function.prototype.caller</a> </li>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/arguments">Function.prototype.arguments</a> </li>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Deprecated_caller_or_arguments_usage">ReferenceError: deprecated
  caller or arguments usage</a> </li>
</ul>