<h2>Why is this an issue?</h2>
<p>In JavaScript, throwing literals (primitive values like strings, numbers, booleans, etc.) as exceptions is generally discouraged. While it is
syntactically valid to throw literals, it is considered a best practice to throw instances of the <code>Error</code> class or its subclasses
instead.</p>
<p>Throwing an instance of the <code>Error</code> class allows you to provide more meaningful information about the error.</p>
<p>The <code>Error</code> class and its subclasses provide properties like <code>message</code> and <code>stack</code> that can be used to convey
useful details about the error, such as a description of the problem, the context in which it occurred, or a stack trace for debugging.</p>

```ts
throw 404;                              // Noncompliant
throw "Invalid negative index.";        // Noncompliant
```
<p>Throwing literals can make it harder to handle and differentiate between different types of errors. Instead, you should use one of the exception
types specifically created for the purpose or define your own subclass of the <code>Error</code> class.</p>

```ts
throw new Error("Status: " + 404);
throw new RangeError("Invalid negative index.");
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/throw"><code>throw</code></a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Error">Error</a> </li>
</ul>