<h2>Why is this an issue?</h2>
<p>An empty interface is equivalent to an empty object ('{}'). Normally you cannot directly assign an object literal to a type when the object literal
contains more properties than are specified in the type. But in the case of an empty interface, this check is not done, and such assignments will be
successful. The result is highly likely to confuse maintainers.</p>
<h3>Noncompliant code example</h3>

```ts
interface A {}  // Noncompliant
```
<h3>Compliant solution</h3>

```ts
interface A {
  foo: number;
}
```
<h3>Exceptions</h3>
<p>No issue is raised if the empty interface extends a <a href="https://www.typescriptlang.org/docs/handbook/utility-types.html">TypeScript utility
type</a>.</p>

```ts
interface A {
  foo: number;
  bar: string;
}

interface B extends Pick<A, 'foo'> {}
```