<h2>Why is this an issue?</h2>
<p>Setting timeouts with Mocha allows you to control the maximum time a test case or suite can take to execute. However, incorrect usage or excessive
timeout values can lead to undesired consequences and impact the effectiveness of your test suite. For example, setting a timeout by calling
<code>this.timeout()</code> with a value greater than the <a
href="https://developer.mozilla.org/en-US/docs/Web/API/WindowOrWorkerGlobalScope/setTimeout#Maximum_delay_value">maximum delay</a> (2,147,483,647 ms)
will cause the timeout to be disabled.</p>

```ts
describe("testing this.timeout", function() {
  it("unexpectedly disables the timeout", function(done) {
    this.timeout(2147483648); // Noncompliant: the timeout is disabled
  });
});
```
<p>When using <code>this.timeout()</code>, make sure to set a reasonable value that allows your tests to complete within a reasonable timeframe.</p>

```ts
describe("testing this.timeout", function() {
  it("sets the timeout to 1'000 milliseconds", function(done) {
    this.timeout(1000);
  });
});
```
<p>If the goal is really to disable the timeout, set it to zero instead.</p>

```ts
describe("testing this.timeout", function() {
  it("disables the timeout as expected", function(done) {
    this.timeout(0);
  });
});
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Mocha Documentation - <a href="https://mochajs.org/#timeouts">Timeouts</a> </li>
  <li> Mocha Documentation - <a href="https://mochajs.org/#hook-level">Disabling timeouts</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/API/setTimeout#maximum_delay_value">Maximum_delay_value</a> </li>
</ul>