<h2>Why is this an issue?</h2>
<p>In JavaScript, every value can be coerced into a boolean value: either <code>true</code> or <code>false</code>. Values that are coerced into
<code>true</code> are said to be <a href="https://developer.mozilla.org/en-US/docs/Glossary/Truthy"><em>truthy</em></a>, and those coerced into
<code>false</code> are said to be <a href="https://developer.mozilla.org/en-US/docs/Glossary/Falsy"><em>falsy</em></a>.</p>
<p>Explicit conversion to a boolean can be done with double negation (<code>!!</code>) or a <code>Boolean</code> call. Depending on the context, this
may be redundant as JavaScript uses implicit type coercion and automatically converts values to booleans when used with logical operators, conditional
statements, or any boolean context.</p>

```ts
if (!!foo) { // Noncompliant: redundant '!!'
    // ...
}

if (Boolean(foo)) {  // Noncompliant: redundant 'Boolean' call
    // ...
}
```
<p>A redundant boolean cast affects code readability. Not only the condition becomes more verbose but it also misleads the reader who might question
the intent behind the extra cast. The condition can be written without the Boolean cast.</p>

```ts
if (foo) {
    // ...
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean#boolean_coercion">Boolean
  coercion</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Glossary/Type_coercion">Type coercion</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Glossary/Truthy">Truthy</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Glossary/Falsy">Falsy</a> </li>
</ul>
<h3>Articles &amp; blog posts</h3>
<ul>
  <li> <a href="https://blog.alexdevero.com/truthy-falsy-values-in-javascript/">Alex Devero, How Truthy and Falsy Values in JavaScript Work</a> </li>
</ul>