<h2>Why is this an issue?</h2>
<p>TypeScript provides two ways to tell the compiler that a literal value should be typed as a literal type like <code>42</code> rather than the
primitive one <code>number</code>:</p>
<ul>
  <li> <code>as const</code> tells TypeScript to infer the literal type automatically </li>
  <li> <code>as T</code> where <code>T</code> denotes a literal type to instruct TypeScript to infer the literal type explicitly </li>
</ul>
<p>In practice, <code>as const</code> is preferred because the type checker doesn’t need re-typing the literal value.</p>
<p>Therefore, the rule flags occurrences of explicit literal types that can be replaced with an <code>as const</code> assertion.</p>
<h2>How to fix it</h2>
<p>Replace the explicit literal type assertion with <code>as const</code>.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
class Foo {
  public static foo: 42 = 42; // Noncompliant

  // ...
}
```
<h4>Compliant solution</h4>

```ts
class Foo {
  public static foo = 42 as const;

  // ...
}
```
<h4>Noncompliant code example</h4>

```ts
let foo = { bar: 'baz' as 'baz' };
```
<h4>Compliant solution</h4>

```ts
let foo = { bar: 'baz' as const };
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> TypeScript Documentation - <a href="https://www.typescriptlang.org/docs/handbook/2/everyday-types.html#literal-types">Literal types</a> </li>
</ul>