<h2>Why is this an issue?</h2>
<p>TypeScript allows declaring the type of a function in two different ways:</p>
<ul>
  <li> Function type: <code>() ⇒ number</code> </li>
  <li> Object type with a call signature: <code>{ (): number }</code> </li>
</ul>
<p>The function type syntax is generally preferred for being more concise.</p>
<h2>How to fix it</h2>
<p>Use a function type instead of an interface or object type literal with a single call signature.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
function apply(f: { (): string }): string {
  return f();
}
```
<h4>Compliant solution</h4>

```ts
function apply(f: () => string): string {
  return f();
}
```
<h4>Noncompliant code example</h4>

```ts
interface Foo {
  (): number;
}
```
<h4>Compliant solution</h4>

```ts
type Foo = () => number;
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> TypeScript Documentation - <a href="https://www.typescriptlang.org/docs/handbook/2/functions.html#function-type-expressions">Function Type
  Expressions</a> </li>
</ul>