<h2>Why is this an issue?</h2>
<p>In React, calling <code>setState</code> is the primary way to update a component’s state. However, calling <code>setState</code> is often
asynchronous. React batches state updates for performance reasons, which means that when you call <code>setState</code>, React doesn’t immediately
update the state and trigger a re-render. Instead, it schedules the update for later, and multiple <code>setState</code> calls within the same event
handler or function may be batched together. This can lead to unexpected behavior if you assume that state updates are immediate. Therefore, you
should not rely on their values for calculating the next state.</p>

```ts
function increment() {
  this.setState({count: this.state.count + 1}); // Noncompliant
}
```
<p>To mitigate this, you should use functional updates when the new state depends on the previous state, ensuring that you’re always working with the
latest state. This can be done with a second form of <code>setState</code> that accepts a function rather than an object.</p>

```ts
function increment() {
  this.setState(prevState => ({count: prevState.count + 1}));
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> React Documentation - <a href="https://react.dev/reference/react/Component#setstate">setState</a> </li>
  <li> React Documentation - <a href="https://react.dev/reference/react/Component#setstate-caveats">setState caveats</a> </li>
</ul>