<h2>Why is this an issue?</h2>
<p>Referring to <code>this</code> in React functional components would be an error because the components are just regular JavaScript functions and do
not have an object associated with them. Functional components receive their props as a first argument to the component function, so you can access
them directly, and it is a common practice to destructure them right away.</p>

```ts
function UserProfile({firstName, lastName}){
    return (
        <div className="user">{firstName} {lastName}</div>
    );
}
```
<p>React also supports legacy class-based components, where <code>this</code> keyword refers to the component instance object, but this style of
writing components is no longer recommended, and mixing it with functional components will lead to errors.</p>

```ts
function MyComponent(props){
    const foo = this.props.bar; // Noncompliant: remove 'this'
    return (
        <div>{foo}</div>
    );
}
```
<p>To fix the issue, remove references to <code>this</code> from your functional component code. Make also sure you are not mixing functional and
class-based component styles.</p>

```ts
function MyComponent({bar}){
    const foo = bar;
    return (
        <div>{foo}</div>
    );
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> React Documentation - <a href="https://react.dev/learn/your-first-component#defining-a-component">Defining a Component</a> </li>
  <li> React Documentation - <a href="https://react.dev/learn/passing-props-to-a-component">Passing Props to a Component</a> </li>
  <li> React Documentation - <a href="https://react.dev/reference/react/Component">Legacy class components</a> </li>
</ul>