<h2>Why is this an issue?</h2>
<p>Leaving unused props in a React component can make the code harder to understand and maintain. Other developers may wonder why certain props are
passed to a component if they are not used. Unused props can also increase the size of the component’s memory footprint and impact performance. This
is especially true if the unused props are large objects or arrays. Furthermore, if a prop is unused, it may indicate that the developer did not
complete the implementation as he intended initially or made a mistake while writing the component.</p>
<p>To avoid these issues, you should remove any unused props from React components. This helps keep the codebase clean, improves performance, and
enhances code readability.</p>
<h2>How to fix it in PropTypes</h2>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
import PropTypes from 'prop-types';
import React from 'react';

class Hello extends React.Component {
  render() {
    return (
      <h1>Hello</h1>
    );
  }
}

Hello.propTypes = {
  name: PropTypes.string
};
```
<h4>Compliant solution</h4>

```ts
import PropTypes from 'prop-types';
import React from 'react';

class Hello extends React.Component {
  render() {
    return (
      <h1>Hello {this.props.name}</h1>
    );
  }
}

Hello.propTypes = {
  name: PropTypes.string
};
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> React Documentation - <a href="https://react.dev/learn/passing-props-to-a-component">Passing Props to a Component</a> </li>
  <li> React Documentation - <a href="https://react.dev/reference/react/Component#static-proptypes">static propTypes</a> </li>
  <li> React Documentation - <a href="https://react.dev/learn/typescript#typescript-with-react-components">TypeScript with React Components</a> </li>
</ul>