<h2>Why is this an issue?</h2>
<p>ARIA (Accessible Rich Internet Applications) attributes are used to enhance the accessibility of web content and web applications. These attributes
provide additional information about an element’s role, state, properties, and values to assistive technologies like screen readers.</p>
<p>Each role in ARIA has a set of required attributes that must be included for the role to be properly understood by assistive technologies. These
attributes are known as "required aria-* properties".</p>
<p>For example, if an element has a role of "checkbox", it must also include the aria-checked property. This property indicates whether the checkbox
is checked (true), unchecked (false), or in a mixed state (mixed).</p>
<p>This rule checks that each element with a defined ARIA role also has all required attributes.</p>
<h2>How to fix it</h2>
<p>Check that each element with a defined ARIA role also has all required attributes.</p>

```ts
<div role="checkbox">Unchecked</div> {/* Noncompliant: aria-checked is missing */}
```
<p>To fix the code add missing aria-* attributes.</p>

```ts
<div role="checkbox" aria-checked={isChecked}>Unchecked</div>
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/ARIA_Techniques">Using ARIA: Roles, states, and
  properties</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles">ARIA roles (Reference)</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Attributes">ARIA states and properties (Reference)</a>
  </li>
</ul>
<h3>Standards</h3>
<ul>
  <li> W3C - <a href="https://www.w3.org/TR/wai-aria-1.2/">Accessible Rich Internet Applications (WAI-ARIA) 1.2</a> </li>
</ul>