<h2>Why is this an issue?</h2>
<p>Heading elements are represented by the tags <code>&lt;h1&gt;</code> through <code>&lt;h6&gt;</code>, with <code>&lt;h1&gt;</code> being the
highest level and <code>&lt;h6&gt;</code> being the lowest. These elements are used to structure the content of the page and create a hierarchical
outline that can be followed by users and search engines alike.</p>
<p>In the context of accessibility, heading elements play a crucial role. They provide a way for users, especially those using assistive technologies
like screen readers, to navigate through the content of a webpage. By reading out the headings, screen readers can give users an overview of the
content and allow them to jump to the section they’re interested in.</p>
<p>If a heading element is empty, it can lead to confusion as it doesn’t provide any information about the content that follows. This can make
navigation difficult for users relying on screen readers, resulting in a poor user experience and making the website less accessible for people with
visual impairments.</p>
<p>Therefore, to ensure your website is accessible to all users, it’s important to always include meaningful content in your heading elements.</p>
<h2>How to fix it</h2>
<p>Do not leave empty your heading elements.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
function JavaScript101() {
  return (
    <>
      <h1>JavaScript Programming Guide</h1>
      <p>An introduction to JavaScript programming and its applications.</p>

      <h2>JavaScript Basics</h2>
      <p>Understanding the basic concepts in JavaScript programming.</p>

      <h3>Variables</h3>
      <p>Explanation of what variables are and how to declare them in JavaScript.</p>

      <h3 aria-hidden>Data Types</h3> // Noncompliant
      <p>Overview of the different data types in JavaScript.</p>

      <h3 /> // Noncompliant
      <p>Understanding how to declare and use functions in JavaScript.</p>
    </>
  );
}
```
<h4>Compliant solution</h4>

```ts
function JavaScript101() {
  return (
    <>
      <h1>JavaScript Programming Guide</h1>
      <p>An introduction to JavaScript programming and its applications.</p>

      <h2>JavaScript Basics</h2>
      <p>Understanding the basic concepts in JavaScript programming.</p>

      <h3>Variables</h3>
      <p>Explanation of what variables are and how to declare them in JavaScript.</p>

      <h3>Data Types</h3>
      <p>Overview of the different data types in JavaScript.</p>

      <h3>Functions</h3>
      <p>Understanding how to declare and use functions in JavaScript.</p>
    </>
  );
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/HTML/Element/Heading_Elements">Heading elements</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Attributes/aria-hidden">aria-hidden</a> </li>
  <li> WCAG - <a href="https://www.w3.org/TR/UNDERSTANDING-WCAG20/navigation-mechanisms-descriptive.html">Headings and Labels</a> </li>
</ul>