# Strong IBOutlet

@IBOutlets shouldn't be declared as weak.

* **Identifier:** strong_iboutlet
* **Supports autocorrection:** Yes
* **Kind:** lint
* **Analyzer rule:** No
* **Minimum Swift compiler version:** 3.0.0
* **Default configuration:** warning

## Non Triggering Examples

```swift
class ViewController: UIViewController {
    @IBOutlet var label: UILabel?
}
```

```swift
class ViewController: UIViewController {
    weak var label: UILabel?
}
```

## Triggering Examples

```swift
class ViewController: UIViewController {
    @IBOutlet ↓weak var label: UILabel?
}
```

```swift
class ViewController: UIViewController {
    @IBOutlet ↓unowned var label: UILabel!
}
```

```swift
class ViewController: UIViewController {
    @IBOutlet ↓weak var textField: UITextField?
}
```