This check detects comments containing task tags (e.g., `TODO`).
What exactly is considered as a task tag depends on the check configuration.

# Why is This a Problem?

Task tags (e.g., `TODO`) are a problem for two related but distinct reasons:

1. When there is no process to manage and get rid of them, they often accumulate over time, especially when resolving them is not explicitly planned.
    As a consequence, very old task tags may remain in the codebase for a long time.
    These tend to be particularly confusing, because the comment is often no longer relevant, or because it is unclear what work needs to be done, especially if the original author is unknown or has left the development team.

2. They can also cause problems in the opposite direction:
    Relevant tasks are hard to track if they are only mentioned as comment in the code but not reflected in the issue tracker.

## Exceptions

Comments with task tags which also contain a reference to a ticket in an issue tracker can be useful to point out an unresolved task to the reader.
If this should be an allowed use of task tags, this check can be configured to ignore such comments.

# How Can I Resolve This?

Use task tags only as short-term markers during your ongoing development task and remove them from the code before finishing the task.
In a branch-based development process, task tags should be resolved before the code is merged into an upstream branch.
If the task itself has not been resolved, create an issue in your issue tracker for it.

Depending on the configuration, it is also possible to fix the finding by adding a link to an issue which tracks resolution of the comment.

## Example (Before)

``` java
// TODO Find out why ...
```
``` java
// TODO (John Doe) Fix issue ...
```

## Example (After)

These only work if the check is configured accordingly:
``` java
// TODO PROJ-12345 Fix issue ...
// (no finding, references Jira issue)
```
``` java
// TODO #12345 Fix issue ...
// (no finding, references GitHub issue)
```
