import{_ as t,c as a,ak as i,o as s}from"./chunks/framework.D4LivsWb.js";const p=JSON.parse('{"title":"Configuring Build Completeness Check for Merge Requests","description":"","frontmatter":{"title":"Configuring Build Completeness Check for Merge Requests"},"headers":[],"relativePath":"howto/configuring-build-completeness-check/index.md","filePath":"howto/configuring-build-completeness-check/index.md"}'),o={name:"howto/configuring-build-completeness-check/index.md"};function n(l,e,r,c,d,u){return s(),a("div",null,[...e[0]||(e[0]=[i('<h1 id="configuring-build-completeness-check-for-merge-requests" tabindex="-1">Configuring Build Completeness Check for Merge Requests <a class="header-anchor" href="#configuring-build-completeness-check-for-merge-requests" aria-label="Permalink to &quot;Configuring Build Completeness Check for Merge Requests&quot;">​</a></h1><div class="warning custom-block"><p class="custom-block-title">Supported Voting Connectors</p><p>This feature is currently available for <a href="./../connecting-version-control-system/bitbucket/">Bitbucket Data Center</a>, <a href="./../connecting-version-control-system/github/">GitHub</a> and <a href="./../connecting-version-control-system/gitlab/">GitLab</a> only.</p></div><p>Voting connectors can be configured to wait for specific build jobs before annotating the merge request with test gap data. This ensures that test coverage in Teamscale is complete and lets you know whether Teamscale expects more test data to arrive from build pipelines or not.</p><h2 id="enabling-the-build-completeness-check" tabindex="-1">Enabling the Build Completeness Check <a class="header-anchor" href="#enabling-the-build-completeness-check" aria-label="Permalink to &quot;Enabling the Build Completeness Check&quot;">​</a></h2><p>To enable and configure the build completeness check for merge requests, you need to configure the <em>Included build jobs</em> and <em>Excluded build jobs</em> options in the connector.</p><p>You could do so by adding regular expressions describing the build jobs that Teamscale should wait for before annotating the merge requests with test gap data.</p><p>Please keep in mind the following when configuring these options:</p><ul><li>If the options are left empty, that means that the feature is disabled and Teamscale will not wait for any build jobs.</li><li>If any of the options is set, that means that the feature is enabled and Teamscale expects <strong>at least one build job</strong> to match the configured regular expressions.</li></ul><h2 id="configuring-build-completeness-check-intervals" tabindex="-1">Configuring Build Completeness Check Intervals <a class="header-anchor" href="#configuring-build-completeness-check-intervals" aria-label="Permalink to &quot;Configuring Build Completeness Check Intervals&quot;">​</a></h2><p>Teamscale periodically polls the code collaboration platform for changes regarding the merge requests&#39; configured build jobs to get updates about their status.</p><h3 id="build-jobs-polling-interval" tabindex="-1">Build jobs polling interval <a class="header-anchor" href="#build-jobs-polling-interval" aria-label="Permalink to &quot;Build jobs polling interval&quot;">​</a></h3><p>The <em>Build jobs polling interval</em> connector option sets the delay used for polling the merge requests&#39; build jobs. It is set to 10 minutes by default, and you can increase or decrease the polling interval as desired.</p><p>However, we recommend using the default setting and only decreasing that interval, if the code collaboration platform cannot reach Teamscale via webhook at all.</p><h3 id="merge-requests-last-updated-timeframe" tabindex="-1">Merge requests last updated timeframe <a class="header-anchor" href="#merge-requests-last-updated-timeframe" aria-label="Permalink to &quot;Merge requests last updated timeframe&quot;">​</a></h3><p>When Teamscale periodically polls the code collaboration platform for build jobs changes, it checks the merge requests last updated within a specific timeframe.</p><p>By default, Teamscale checks the merge requests updated within the last 24 hrs, but this timeframe can be adjusted by passing the following <a href="./../../reference/administration-ts-installation/#jvm-arguments">JVM argument</a> on the start of Teamscale:</p><p><code>-Dcom.teamscale.merge-request.merge_requests_last_update_period_seconds=86400</code></p><h2 id="configuring-build-status-webhook-service" tabindex="-1">Configuring Build Status Webhook Service <a class="header-anchor" href="#configuring-build-status-webhook-service" aria-label="Permalink to &quot;Configuring Build Status Webhook Service&quot;">​</a></h2><p>Some code collaboration platforms do not trigger webhooks for build job status changes (e.g. Bitbucket Data Center). So in order to overcome this limitation and enable Teamscale to receive real-time updates, the build status webhook service can be used to notify Teamscale about the build jobs&#39; changes.</p><p>In such cases, we recommend calling this service at the beginning and ending of the build job script to signal the start and end of the build job respectively.</p><p>Below is an example of how the service call would look like for a Bitbucket Data Center build job.</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">curl</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -X</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> POST</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &#39;http://&lt;TEAMSCALE_URL&gt;/api/projects/&lt;PROJECT&gt;/build-web-hook?revision=&lt;GIT_COMMIT&gt;&amp;repository-url=&lt;REPO_URL&gt;&amp;repository-platform=bitbucket_server&#39;</span></span></code></pre></div>',22)])])}const g=t(o,[["render",n]]);export{p as __pageData,g as default};
