import{_ as r,a as k,b as o}from"./chunks/upload_permissions.CrL4J5u2.js";import{_ as d,c as E,ak as l,O as e,z as t,L as h,o as g,b as s,x as i}from"./chunks/framework.D4LivsWb.js";const F=JSON.parse('{"title":"Coverage for Java with Kubernetes","description":"","frontmatter":{"title":"Coverage for Java with Kubernetes"},"headers":[],"relativePath":"howto/setting-up-profiler-tga/java-with-kubernetes/index.md","filePath":"howto/setting-up-profiler-tga/java-with-kubernetes/index.md"}'),c={name:"howto/setting-up-profiler-tga/java-with-kubernetes/index.md"};function y(u,a,m,f,v,A){const n=h("PluginTabsTab"),p=h("PluginTabs");return g(),E("div",null,[a[3]||(a[3]=l('<h1 id="recording-test-coverage-for-java-with-kubernetes" tabindex="-1">Recording Test Coverage for Java with Kubernetes <a class="header-anchor" href="#recording-test-coverage-for-java-with-kubernetes" aria-label="Permalink to &quot;Recording Test Coverage for Java with Kubernetes&quot;">​</a></h1><p>This how-to will show you how to set up test coverage recording for a Java application deployed to a Kubernetes cluster, or any other language running on the Java Virtual Machine (JVM), so you can use <a href="./../../../introduction/improving-test-quality/">Test Gap analysis</a>. This setup works for both automated and <a href="./../manual-tests/">manual tests</a>.</p><p>Coverage is recorded using the <a href="./../../../reference/coverage-profilers/teamscale-java-profiler/">Teamscale Java Profiler</a>, which is a Java profiler that can attach to any JVM to record the lines of code executed during any test (manual or automated). The profiler also handles the automatic upload of the recorded test coverage to Teamscale on shutdown of the JVM or in configurable time intervals.</p><h2 id="prerequisite-generate-git-properties" tabindex="-1">Prerequisite: Generate <code>git.properties</code> <a class="header-anchor" href="#prerequisite-generate-git-properties" aria-label="Permalink to &quot;Prerequisite: Generate `git.properties`&quot;">​</a></h2><p>To upload the coverage to the correct commit in Teamscale, add a <code>git.properties</code> file to your jar/war. Depending on your environment there are multiple options:</p>',5)),e(p,null,{default:t(()=>[e(n,{label:"Maven"},{default:t(()=>[...a[0]||(a[0]=[s("p",null,"Just add the following plugin to your build:",-1),s("div",{class:"language-xml vp-adaptive-theme"},[s("button",{title:"Copy Code",class:"copy"}),s("span",{class:"lang"},"xml"),s("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"<"),s("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"build"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    <"),s("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"plugins"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"		<"),s("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"plugin"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"			<"),s("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"groupId"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">io.github.git-commit-id</"),s("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"groupId"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"			<"),s("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"artifactId"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">git-commit-id-maven-plugin</"),s("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"artifactId"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"			<"),s("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"version"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">9.0.1</"),s("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"version"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"			<"),s("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"executions"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"				<"),s("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"execution"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"					<"),s("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"id"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">get-the-git-infos</"),s("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"id"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"					<"),s("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"goals"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"						<"),s("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"goal"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">revision</"),s("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"goal"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"					</"),s("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"goals"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"					<"),s("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"phase"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">initialize</"),s("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"phase"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"				</"),s("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"execution"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"			</"),s("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"executions"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"			<"),s("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"configuration"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"				<"),s("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"generateGitPropertiesFile"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">true</"),s("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"generateGitPropertiesFile"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"			</"),s("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"configuration"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"		</"),s("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"plugin"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    </"),s("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"plugins"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"</"),s("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"build"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")])])])],-1)])]),_:1}),e(n,{label:"Gradle"},{default:t(()=>[...a[1]||(a[1]=[s("p",null,[i("You can achieve this by applying the "),s("a",{href:"https://plugins.gradle.org/plugin/com.gorylenko.gradle-git-properties",target:"_blank",rel:"noreferrer"},"gradle-git-properties plugin"),i(", as shown in the following example:")],-1),s("div",{class:"language-groovy vp-adaptive-theme"},[s("button",{title:"Copy Code",class:"copy"}),s("span",{class:"lang"},"groovy"),s("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"plugins {")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    id "),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"com.gorylenko.gradle-git-properties"'),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," version "),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"2.4.2"')]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"}")])])])],-1)])]),_:1}),e(n,{label:"Other"},{default:t(()=>[...a[2]||(a[2]=[s("p",null,[i("In case you are not using Git with Maven or Gradle you can also generate the "),s("code",null,"git.properties"),i(" file in your build. This file needs to contain a "),s("code",null,"git.commit.id"),i(" property corresponding to the respective code revision the current application was built from:")],-1),s("div",{class:"language-properties vp-adaptive-theme"},[s("button",{title:"Copy Code",class:"copy"}),s("span",{class:"lang"},"properties"),s("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"git.commit.id"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=6f735064d5a125d35a546675ee61a5f4a0f840aa")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"# When you intend to upload to Artifactory also add the following")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"git.branch"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=master")]),i(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"git.commit.time"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=1593781474000")])])])],-1),s("p",null,"The file needs to be packaged into the jar or war file of your application.",-1)])]),_:1})]),_:1}),a[4]||(a[4]=l(`<p>Now build and deploy your application.</p><h2 id="adjust-your-dockerfile" tabindex="-1">Adjust Your Dockerfile <a class="header-anchor" href="#adjust-your-dockerfile" aria-label="Permalink to &quot;Adjust Your Dockerfile&quot;">​</a></h2><p>This step is necessary so all remaining coverage is uploaded when your application is shut down.</p><p>By default, the agent sends the coverage it collected when the JVM inside your Docker container is shut down. This requires that the JVM receives the <code>SIGTERM</code> signal sent by your orchestration tooling. Thus, you&#39;ll need to ensure that the JVM is the main process inside the docker image. This can be achieved by using <code>exec</code> to replace the shell process with your JVM process:</p><div class="language-docker vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">docker</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># this will not work:</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">CMD</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> java -jar /your.jar</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># use this instead:</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">CMD</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> exec java -jar /your.jar</span></span></code></pre></div><p>The same applies if you&#39;re using <code>ENTRYPOINT</code> instead of <code>CMD</code>:</p><div class="language-docker vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">docker</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># this will not work:</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">ENTRYPOINT</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> java -jar /your.jar</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;"># use this instead:</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">ENTRYPOINT</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> exec java -jar /your.jar</span></span></code></pre></div><p>If your application is wrapped inside a start script, you&#39;ll likewise need to ensure that you use <code>exec</code> to replace the shell process with the JVM process.</p><h2 id="set-up-a-profiler-configuration" tabindex="-1">Set Up a Profiler Configuration <a class="header-anchor" href="#set-up-a-profiler-configuration" aria-label="Permalink to &quot;Set Up a Profiler Configuration&quot;">​</a></h2><p>The profiler&#39;s configuration can be stored within Teamscale. This makes it easy to change and audit. To configure the profiler for your application, go to the <em>Project Configuration</em> &gt; <em>Coverage Profilers</em> view. Open the dropdown of the <em>New profiler configuration</em> button and click on <em>Create for a JVM (Java, Kotlin, ...) project</em>.</p><p><img src="`+r+'" alt="The Java Profiler Configuration Wizard" style="max-width:400px;" width="612" height="174" data-zoom="true"></p><p>You will be presented with a dialog that lets you generate a profiler configuration for a Teamscale project.</p><p><img src="'+k+`" alt="The Teamscale Java Profiler Configuration Wizard" width="1282" height="1168" data-zoom="true"></p><ul><li>Select the project that you want to collect coverage for.</li><li>Choose a configuration ID. This ID will be used when starting the profiler so that it knows which configuration to use.</li><li>Select a <a href="./../../../glossary/#partition"><em>partition</em></a>, which is a logical name that groups related coverage, e.g., the type of test that will be profiled (e.g., <em>Manual Test</em>, <em>Unit Test</em>, <em>Regression Test</em>).</li><li>Select all packages that should be profiled. Subpackages are included as well.</li></ul><div class="tip custom-block"><p class="custom-block-title">Selecting Appropriate Packages</p><p>Teamscale automatically suggests packages to profile. Please review them carefully.</p><p>Please ensure the packages you select are &quot;future-proof&quot;, i.e., they also match packages you might add in the future. This saves you time later, because you won&#39;t have to adjust the profiler configuration whenever you add new packages.</p><p>Make sure not to profile widespread packages that are also used by third-party software, e.g. <code>net.java</code> or <code>com</code>.</p></div><p>Finally, click <em>Save</em>.</p><p>The generated profiler configuration looks similar to the following:</p><div class="language-properties vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">properties</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">includes</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=*com.company.product.*</span><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">;*com.company.commons.*</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">teamscale-project</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=my-application</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">teamscale-partition</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=Manual Tests</span></span></code></pre></div><p>Next, please go back to the <em>Project Configuration</em> &gt; <em>Coverage Profilers</em> overview. Click on the <i class="users icon"></i> button next to the profiler configuration that you just created and assign <code>Viewer</code> permissions to the technical user that the profiler uses to connect to Teamscale.</p><p>Next, please go to <em>Admin</em> &gt; <em>Users</em> and select the technical user whose credentials should be used for the coverage upload. Ensure that the user has the <code>Perform External Uploads</code> permission for the project. You can achieve this by assigning the pre-defined <code>Build</code> project role to the user.</p><p><img src="`+o+`" alt="Build user permission settings" width="2012" height="796" data-zoom="true"></p><p>Then generate an access key by clicking on <em>Generate New Access Key</em> and save it. We will need it in the next step.</p><h2 id="deploy-the-profiler" tabindex="-1">Deploy the Profiler <a class="header-anchor" href="#deploy-the-profiler" aria-label="Permalink to &quot;Deploy the Profiler&quot;">​</a></h2><p>To deploy the profiler to a pod, you need to create a volume to hold the profiler files, mount it into each container that should be profiled and activate the profiler with a few environment variables. Here is a simple example deployment YAML file with the necessary modifications:</p><div class="language-yaml vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">yaml</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">apiVersion</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">apps/v1</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">kind</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">Deployment</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">metadata</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">  name</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">backend</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">  labels</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">    app</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">backend</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">spec</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">  selector</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">    matchLabels</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">      app</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">backend</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">  template</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">    metadata</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">      labels</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">        app</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">backend</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">    spec</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">      volumes</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:</span></span>
<span class="line highlighted"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">      # add a volume that will hold the profiler files</span></span>
<span class="line highlighted"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">      # it can be shared between all containers in this pod</span></span>
<span class="line highlighted"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      - </span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">name</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">teamscale-java-profiler</span></span>
<span class="line highlighted"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">        emptyDir</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: {}</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">      initContainers</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:</span></span>
<span class="line highlighted"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">      # add our init container to copy the profiler to the \`teamscale-java-profiler\` volume</span></span>
<span class="line highlighted"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      - </span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">name</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">prepare-profiler</span></span>
<span class="line highlighted"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">        image</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">cqse/teamscale-jacoco-agent:latest</span></span>
<span class="line highlighted"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">        volumeMounts</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:</span></span>
<span class="line highlighted"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        - </span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">name</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">teamscale-java-profiler</span></span>
<span class="line highlighted"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">          mountPath</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">/transfer</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">      containers</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      - </span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">name</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">backend</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">        image</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">backend:latest</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      </span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">        volumeMounts</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:</span></span>
<span class="line highlighted"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">        # mount the profiler</span></span>
<span class="line highlighted"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        - </span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">name</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">teamscale-java-profiler</span></span>
<span class="line highlighted"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">          mountPath</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">/teamscale-java-profiler</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">        env</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:</span></span>
<span class="line highlighted"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">        # enable the profiler</span></span>
<span class="line highlighted"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">        # replace with your Teamscale instance&#39;s URL and username</span></span>
<span class="line highlighted"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        - </span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">name</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">JAVA_TOOL_OPTIONS</span></span>
<span class="line highlighted"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">          value</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;-javaagent:/teamscale-java-profiler/teamscale-jacoco-agent.jar=teamscale-server-url=https://your.teamscale.url,teamscale-user=your-build-user-name&quot;</span></span>
<span class="line highlighted"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">        # set the access token from a secret</span></span>
<span class="line highlighted"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        - </span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">name</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">TEAMSCALE_ACCESS_TOKEN</span></span>
<span class="line highlighted"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">          valueFrom</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:</span></span>
<span class="line highlighted"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">            secretKeyRef</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:</span></span>
<span class="line highlighted"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">              name</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">teamscale</span></span>
<span class="line highlighted"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">              key</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">access-token</span></span>
<span class="line highlighted"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">        # set the profiler configuration ID from the previous step</span></span>
<span class="line highlighted"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        - </span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">name</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">TEAMSCALE_JAVA_PROFILER_CONFIG_ID</span></span>
<span class="line highlighted"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">          value</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;my-application-backend&quot;</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">      # set an appropriate termination grace period so the profiler has</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">      # a chance to upload coverage. See below.</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">      terminationGracePeriodSeconds</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">180</span></span></code></pre></div><p>We recommend storing the access token in a secret, e.g:</p><div class="language-yaml vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">yaml</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">apiVersion</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">v1</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">kind</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">Secret</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">metadata</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">  name</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">teamscale</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">data</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">  access-token</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">BASE64_ENCODED_ACCESS_TOKEN</span></span></code></pre></div><div class="warning custom-block"><p class="custom-block-title">Istio: Additional Steps Required</p><p>If you are using Istio in your cluster, <a href="https://istio.io/latest/docs/ops/common-problems/injection/#pod-or-containers-start-with-network-issues-if-istio-proxy-is-not-ready" target="_blank" rel="noreferrer">you must set <code>holdApplicationUntilProxyStarts</code></a> to ensure the Istio network is fully set up before your application container is started. Otherwise, you may experience connection failures when the Teamscale Java Profiler tries to retrieve its configuration from Teamscale, leading to missing coverage.</p></div><div class="tip custom-block"><p class="custom-block-title">Debugging Setup Problems</p><p>The profiler by default logs to <code>/tmp/teamscale-java-profiler-&lt;PID&gt;-&lt;random string&gt;/logs/</code> inside your Docker container. If the setup does not work as expected, please have a look at the problems reported in this log file.</p><p>You can also make the profiler log debug information to stdout by appending <code>,debug=true</code> to the <code>JAVA_TOOL_OPTIONS</code>.</p></div><h2 id="set-an-appropriate-grace-period" tabindex="-1">Set an Appropriate Grace Period <a class="header-anchor" href="#set-an-appropriate-grace-period" aria-label="Permalink to &quot;Set an Appropriate Grace Period&quot;">​</a></h2><p>When the pod running your application and our profiler is stopped, the profiler will upload all collected coverage to Teamscale. This adds some seconds to your application&#39;s shutdown time. By default, Kubernetes will kill any pod that takes longer than 30s to shut down. This will interrupt the profiler and the coverage data will not be uploaded and is lost.</p><p>Thus, you must set an appropriate <code>terminationGracePeriodSeconds</code> value that is large enough so your application can shut down cleanly and the profiler has a chance to send its coverage data to Teamscale. What &quot;appropriate&quot; means depends on your application. We recommend you run a few experiments to determine how long your application takes to shut down cleanly with and without our profiler enabled and then add some buffer on top of the largest measured value. 3 minutes is a good starting point that usually works even for large applications.</p>`,32))])}const w=d(c,[["render",y]]);export{F as __pageData,w as default};
