import{_ as i,c as o,ak as t,O as s,L as r,o as l}from"./chunks/framework.D4LivsWb.js";const n="/assets/teamscale-create-project.l3P2_G0v.png",c="/assets/profiler-configuration-wizard.jC-BpmkW.png",p="/assets/teamscale-activity-coverage.C4PYuG1T.png",d="/assets/teamscale-activity-details-coverage.DL3LJRdQ.png",b=JSON.parse('{"title":"Setting up Test Gap Analysis (Java)","description":"","frontmatter":{"title":"Setting up Test Gap Analysis (Java)"},"headers":[],"relativePath":"tutorial/setting-up-tga-java/index.md","filePath":"tutorial/setting-up-tga-java/index.md"}'),h={name:"tutorial/setting-up-tga-java/index.md"};function u(g,e,m,f,v,y){const a=r("ZipDownload");return l(),o("div",null,[e[0]||(e[0]=t('<h1 id="setting-up-test-gap-analysis-on-a-java-application-pixelitor" tabindex="-1">Setting up Test Gap Analysis on a Java Application (Pixelitor) <a class="header-anchor" href="#setting-up-test-gap-analysis-on-a-java-application-pixelitor" aria-label="Permalink to &quot;Setting up Test Gap Analysis on a Java Application (Pixelitor)&quot;">​</a></h1><p>As a developer or tester of a Java desktop application, you may use Teamscale <a href="./../../glossary/#test-gap-analysis">Test Gap Analysis (TGA)</a> to improve your testing effectiveness. This tutorial leads you through the setup of TGA on <a href="https://github.com/lbalazscs/Pixelitor" target="_blank" rel="noreferrer">Pixelitor</a>, an open source graphics editor.</p><nav class="table-of-contents"><ul><li><a href="#step-1-setting-up-a-teamscale-project">Step 1: Setting up a Teamscale Project</a></li><li><a href="#step-2-downloading-pixelitor">Step 2: Downloading Pixelitor</a></li><li><a href="#step-3-installing-the-teamscale-java-profiler">Step 3: Installing the Teamscale Java Profiler</a></li></ul></nav><h2 id="step-1-setting-up-a-teamscale-project" tabindex="-1">Step 1: Setting up a Teamscale Project <a class="header-anchor" href="#step-1-setting-up-a-teamscale-project" aria-label="Permalink to &quot;Step 1: Setting up a Teamscale Project&quot;">​</a></h2><p>In Teamscale, go to <em>Project Configuration</em> and click <em>New project</em>.</p><p>Name the new project <code>Pixelitor</code> and choose the analysis profile <em>Java (default)</em>.</p><p>In the <em>Branching Configuration</em>, change all start dates to <code>2019-10-11</code>.</p><p>Click <em>Source Code Repository</em> and select <em>Git</em>. Create a new account named <code>GitHub</code> with the URI <code>https://github.com</code> and without credentials. Set the <em>Path suffix</em> to <code>cqse/Pixelitor</code> and the <em>Default branch name</em> to <code>release/4.2.3</code>.</p><p>We set the analysis start and the branch in a way that we can see the test gaps between version 4.2.2 (released on October 11, 2019) and version 4.2.3.</p><p>Click <em>Create project</em>.</p><p><img src="'+n+'" alt="Create project &quot;Pixelitor&quot; in Teamscale" width="800" height="1601" data-zoom="true"></p><h2 id="step-2-downloading-pixelitor" tabindex="-1">Step 2: Downloading Pixelitor <a class="header-anchor" href="#step-2-downloading-pixelitor" aria-label="Permalink to &quot;Step 2: Downloading Pixelitor&quot;">​</a></h2><p>As a prerequisite for running Pixelitor, install Java 8 or 11, for example from <a href="https://adoptopenjdk.net/releases.html" target="_blank" rel="noreferrer">OpenJDK</a>.</p><p>Next, download Pixelitor from the link below and extract it to an empty directory on your system.</p>',14)),s(a,{title:"Pixelitor 4.2.3",link:"/assets/tutorial/setting-up-tga-java/pixelitor-4.2.3.zip"}),e[1]||(e[1]=t(`<p>Finally, start Pixelitor by executing <code>java -jar Pixelitor-4.2.3.jar</code> in the installation directory to verify that the application starts up.</p><div class="tip custom-block"><p class="custom-block-title">Custom Pixelitor Build</p><p>We&#39;re using a custom build of Pixelitor that includes a <code>git.properties</code> file. The Teamscale Java Profiler uses this file to determine which version of Pixelitor we are testing. The <a href="./../../reference/coverage-profilers/teamscale-java-profiler/#configuration-options">documentation of the Teamscale Java Profiler</a> explains how to configure this, however, for this tutorial, you can just use the downloaded Jar file as-is.</p></div><h2 id="step-3-installing-the-teamscale-java-profiler" tabindex="-1">Step 3: Installing the Teamscale Java Profiler <a class="header-anchor" href="#step-3-installing-the-teamscale-java-profiler" aria-label="Permalink to &quot;Step 3: Installing the Teamscale Java Profiler&quot;">​</a></h2><p>Download <a href="https://github.com/cqse/teamscale-jacoco-agent/releases" target="_blank" rel="noreferrer">the latest release of the Teamscale Java Profiler</a> and extract it into the same directory as Pixelitor. Within the <code>teamscale-jacoco-agent</code> directory create a <code>teamscale.properties</code> file with the following content:</p><div class="language-properties vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">properties</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">url</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=http://localhost:8080</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">username</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=build</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">accesskey</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=your-access-key</span></span></code></pre></div><p>To retrieve the access key navigate to the <em>Admin</em> &gt; <em>Users</em> view, select the <code>build</code> user and then click on <em>Generate New Access Key</em>.</p><p>To configure the profiler, go back to Teamscale and open <em>Project Configuration</em> &gt; <em>Coverage Profilers</em>. In the <em>New profiler configuration</em> dropdown select <em>Create for a JVM (Java, Kotlin, ...) project</em>. Next, select the <code>Pixelitor</code> project in the dialog and enter <code>pixelitor</code> in the <em>Configuration ID</em> field and <code>Manual Tests</code> in the <a href="./../../glossary/#partition"><em>Partition</em></a> field.</p><p>We do this to cluster coverage from manual tests under a descriptive name, separated from the coverage of other testing stages, such as unit tests.</p><p><img src="`+c+'" alt="Profiler configuration wizard" width="1284" height="1166" data-zoom="true"></p><p>Click on <em>Save</em>.</p><p>Now, execute</p><div class="language-shell vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">shell</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">java</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -javaagent:teamscale-jacoco-agent/lib/teamscale-jacoco-agent.jar=config-id=pixelitor</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -jar</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> Pixelitor-4.2.3.jar</span></span></code></pre></div><p>Here,</p><ul><li><code>java [...] -jar Pixelitor-4.2.3.jar</code> will start the application,</li><li><code>-javaagent:teamscale-jacoco-agent/lib/teamscale-jacoco-agent.jar=...</code> registers the profiler,</li><li>and <code>config-id=pixelitor</code> specifies the ID of the profiler configuration that should be used to configure the profiler.</li></ul><p>Once Pixelitor has started, do some things to generate coverage, e.g., create a new image and let loose the artist within you. Once you clicked around a little, close Pixelitor. On shutdown, the Java Profiler will upload the coverage directly to Teamscale.</p><div class="tip custom-block"><p class="custom-block-title">Upload Interval for Long Running Applications</p><p>Coverage is not only uploaded on shutdown, but also regularly every 8 hours. This is especially useful for long-running applications, such as web apps, where the JVM is not shut down after testing.</p><p>The interval can be adapted by adding the option <code>interval=...</code> with the desired number of minutes in the profiler configuration. Setting the interval to 0 disables the periodic upload.</p></div><p>To verify that the upload worked, in Teamscale, go to <em>Activity</em>. Once the data arrived and was processed successfully, the entry on top of the timeline represents the coverage upload.</p><p><img src="'+p+'" alt="Coverage upload in the project activity" width="1164" height="286" data-zoom="true"></p><p>The coverage is appearing on December 11, 2019, due to the <code>git.properties</code> file embedded in the jar. The Teamscale Java Profiler parses the commit ID from this file and uploads the collected coverage to the corresponding time. We do this to ensure that the coverage is associated with the source code corresponding to the version under test.</p><p>You can click on the topmost entry in the <em>Activity</em> perspective to view the coverage you have generated with your manual test:</p><p><img src="'+d+'" alt="Details of the coverage upload, including test coverage" width="1164" height="930" data-zoom="true"></p><div class="tip custom-block"><p class="custom-block-title">Assumption: Reachability of Teamscale</p><p>This guide assumes that the Teamscale server is directly reachable from the test environment via HTTP(S). Alternatively, the profiler can also upload the file to an Azure file storage or Artifactory. If Teamscale is not reachable, the coverage file will be saved to <code>teamscale-jacoco-agent/coverage</code>. For more information, refer to the <a href="./../../reference/coverage-profilers/teamscale-java-profiler/#configuration-options">documentation of our Teamscale Java Profiler</a>.</p></div>',22))])}const x=i(h,[["render",u]]);export{b as __pageData,x as default};
