During an `AUTHORITY-CHECK` it is possible to act as another `USER`.
If the impersonated user has more permissions, this can lead to security problems.

# What Does This Check Look For?

This check reports findings for usages of the `FOR USER` addition within a `AUTHORITY-CHECK` statement.
# Why is This a Problem?

Using the addition `FOR USER` produces a security risk.
This addition can be misused to bypass an authorization check by specifying a user with extensive authorizations.
Usernames should not be passed to the program from outside.
If this is necessary the name must be checked carefully.

# How Can I Resolve This?

Avoid usage of `FOR USER` addition in `SUBMIT` statements.

# Where Can I Learn More?

- [ABAP Keyword Documentation: AUTHORITY-CHECK](https://help.sap.com/doc/abapdocu_latest_index_htm/latest/en-US/index.htm?file=abapauthority-check.htm)
- [ABAP Security Notes: User-Dependent Program Flow](https://help.sap.com/doc/abapdocu_latest_index_htm/latest/en-US/index.htm?file=abenauthorization_object_glosry.htm)
