In SQLScript you can create dynamic SQL using one of the following commands: `EXEC` and `EXECUTE IMMEDIATE`. These commands allow the use of variables in SQLScript where they might not be supported. In these situations you risk injection attacks unless you perform input validation within the procedure. In some cases injection attacks can occur by way of data from another database table. To avoid potential vulnerabilities from injection attacks, consider using the following methods instead of dynamic SQL:

* Use static SQL statements. For example, use the static statement `SELECT` instead of `EXECUTE` `IMMEDIATE` and pass the values in the `WHERE` clause.
* Use server-side JavaScript to write this procedure instead of using SQLScript.
* Perform validation on input parameters within the procedure using either SQLScript or server-side JavaScript.
* Use `APPLY_FILTER` if you need a dynamic `WHERE` condition
* Use the SQL Injection Prevention Function

Source: SAP HANA SQLScript Reference. Document Version: 1.0 - 2016-05-11. SAP SE, Walldorf, Germany, 2016. Chapter 3.1. 