Using the conditional expression `if (0)` or `if (false)` to disable code should be avoided.

# Why is This a Problem?
The disabled code still gets compiled while not being intended to do so.
Moreover, this makes the source code less readable and understandable.

# How Can I Resolve This?
Unused code should be removed from the code base.

## Example (Before)

```c
void nonCompliant() {
    usedCode();
    if (false) {
        unusedCode();
    }
}
```

## Example (After)

```c
void compliant() {
    usedCode();
}
```
