Inconsistent linkage in object or function declarations can lead to errors and confuse developers trying to understand the code.
Ensure that all declarations of an object or function specify the same linkage to maintain clarity.

# What Does This Check Look For?

This check searches for declarations of objects and functions that were previously declared with a different linkage.

# Why is This a Problem?

Using different storage class modifiers (e.g., `static` in one declaration but not in another) for the same object can cause false assumptions about the object's linkage and visibility across translation units.
This inconsistency can lead to linkage errors or unexpected behaviors in projects where object declarations are spread across multiple files.

# How Can I Resolve This?

Ensure that all declarations of the affected object or method use the same storage class modifier.
For example, if an object is intended to be declared within a single translation unit, declare it with `static` in all its declarations.

# Examples

## Non-Compliant

```c
static int counter;           // internal linkage declared here
extern int counter;           // non-compliant: object was already declared with internal linkage before but has external linkage in this declaration

static int someFunction ();
int someFunction () {         // non-compliant: function was already declared with internal linkage before but has no linkage in this definition
    return 1;
}
```

## Compliant

```c
static int counter;           // compliant: only internal linkage declared here

static int someFunction ();
static int someFunction () {  // compliant: definition includes static storage class specifier like the declaration before
    return 1;
}
```

# Where Can I Learn More?

## Guidelines

- [C++ reference: Storage class specifiers](https://en.cppreference.com/w/cpp/language/storage_duration)
- Guideline: MISRA C:2012: 8.8 - The `static` storage class specifier shall be used in all declarations of objects and functions that have internal linkage
- Guideline: AUTOSAR C++14, M3-3-2 - If a function has internal linkage then all re-declarations shall include the static storage class specifier.