Attributes of a struct should be arranged in such a way that minimizes the amount of padding.
By ordering them after size from largest to smallest, the amount of padding is minimized and hence the memory efficiency increased.

# What Does This Check Look For?
This check reports a finding when struct attributes in C/C++ code are ordered in a way that results in excessive memory padding.

# Why is This a Problem?
Memory is a finite resource, and wasteful utilization of it can negatively impact a program's performance.
Padding can increase significantly when struct attributes are not well-ordered, making structs occupy more memory than necessary.

# How Can I Resolve This?
Arrange the attributes within structs by size, placing the largest data types first, then the next largest, and so on down to the smallest.
This helps ensure that the system will use the least amount of padding necessary to align data structures.

# Examples

## Non-Compliant
```C++
struct NonCompliant {
    char x;    // size: 1 byte, followed by 7 bytes of padding
    long y;    // size: 8 bytes,
    int z;     // size: 4 bytes, followed by 4 bytes of padding
};  // non-compliant: Struct takes up 24 bytes of memory due to padding
```

## Compliant
```C++
struct Compliant {
    long y;    // size: 8 bytes
    int z;     // size: 4 bytes
    char x;    // size: 1 byte, followed  by 3 bytes of padding
};  // compliant: Struct takes up 16 bytes of memory, saving 8 bytes compared to non-compliant code
```
# Where Can I Learn More?
- [C++ Reference: Object](https://en.cppreference.com/w/cpp/language/object#Alignment)
- [Microsoft C++, C, and Assembler: Alignment](https://learn.microsoft.com/en-us/cpp/cpp/alignment-cpp-declarations)
