Dividing by or taking the modulo with zero can cause unexpected behavior or errors in your program.
Instead, ensure that any divisor is checked to be non-zero before division and modulo.

# What Does This Check Look For?

This check searches for instances where a division or modulo operation occurs with zero as the divisor.
This check only finds direct divisions by zero. For a more advanced check that takes variable values into consideration, use the _Possible division by zero_ check.

# Why is This a Problem?

Dividing by zero is undefined behavior in many programming languages and can lead to exceptions, fatal runtime errors, or other unwanted behavior (e.g., producing NaN in floating-point operations). Such actions can lead to application crashes or unpredictable outcomes, impacting program reliability and correctness.

# How Can I Resolve This?

Ensure that any divisor in a division or modulo operation is non-zero. This can be achieved through conditional checks or assertions before performing the division. Validating input values or applying logic that guarantees a non-zero divisor are strategies to avoid division by zero and maintain application stability.

# Examples

## Non-Compliant

```java
int result = 10 / 0;
```

## Compliant

```java
if (divisor != 0) {
    int result = 10 / divisor;
} else {
    // Handle divisor == 0 case
}
```
