As a rule of thumb, Python functions should hardly directly terminate the application. Prefer throwing an exception (SystemExit if necessary), so that the caller at least has a chance to appropriately handle it.

Mind that the caller might be a C- or Java-program containing a Python interpreter. In such case the `sys.exit(0)` will terminate the whole application, potentially causing data loss or inconsistent states.

``` python
# good example:
if not foo:
    raise AssertionError( '...' )
# bad example:
if not foo:
    sys.exit(-1)
```