This check detects inclusions of the `signal.h` header which can lead to undefined behavior and non-portable code.

# Why is this a problem?
The implementation of signal handlers from `signal.h` varies significantly among different compilers and platforms.
This can result in undefined behavior and non-portable code.

# How Can I Resolve This?
Don't include `signal.h` and use its functions.
Instead, consider using platform-agnostic APIs or third-party libraries that offer more predictable and safer signal handling mechanisms.

# Examples

## Non-Compliant
```c
#include <signal.h>    // non-compliant: signal.h should not be used
void signalHandler(int signalValue) {
    ...
}
int main() {
    signal(SIGINT, signalHandler);
    ...
}
```

# Where Can I Learn More?
- Guideline: MISRA C:2012: Rule 21.5 - The standard header file <signal.h> shall not be used