Using flexible array members in structures can lead to unexpected behavior when using `sizeof`.
Avoid using flexible array members in structures and opt for alternatives such as pointer arrays or dynamic memory management.

# What Does This Check Look For?

This check identifies uses of flexible array members in C structures or classes.

# Why is This a Problem?

Using flexible array members might lead to ambiguity in the size of an object, especially since `sizeof` might not behave as anticipated.
This could result in unreliable or insecure memory operations that are hard to debug or maintain.

# How Can I Resolve This?

Instead of using flexible array members, you could allocate memory dynamically for the data the array is supposed to hold and store a pointer to this memory in the structure.
This approach makes the memory management more explicit and the size calculations more predictable, improving code maintainability.

# Examples

## Non-Compliant

```C
struct example {
    int size;
    int data[];    // non-compliant: flexible array member
};
```

## Compliant

```C
struct example {
    int size;
    int* data; // compliant: using a pointer for dynamic memory
};
```