Hard-coded credentials like passwords or auth tokens are a potential security risk.
It can be resolved by storing the critical data separately from the code.

# What Does This Check Look For?

This check attempts to detect hard-coded passwords.
For that purpose, it looks for instances of identifier names that suggest credentials might be stored.
For instance, variables named 'password', 'passwd', 'pwd', etc. are flagged.

Additionally,
the default regex `^(?!.*(https?://|www))(?=.*[A-Za-z])(?=.*\d)\S{5,}$` checks if the assigned string is likely to represent a password.
However, this setting can be changed in the configurations.

Passwords that match the pattern:
```text
secretpass123
Wge#5eXYFTugD*ho
4iitS
```

Passwords that would not match the pattern:
```text
noNumbers#&
QPk!SM%^SFCKuwB$
3b
https://website.com
```

# Why is This a Problem?

1. *Security risks*: If passwords are hard-coded into program code, they become not only part of the software's source code, but also they get compiled into the binary and are extractable when no obfuscation was applied. So they can be easily accessed by anyone who has access to the code or binary (developers, hackers, etc.). Attackers can exploit this vulnerability to steal passwords and compromise the system's security.

2. *Difficulty in changing passwords*: Hard-coded passwords are often difficult to change because they require the code to be recompiled and redeployed. This can be time-consuming and disruptive, especially if the software is in production.

3. *Compliance issues*: Many industry and government regulations require the use of secure passwords and the regular rotation of passwords. Hard coding passwords into program code can violate these regulations and lead to compliance issues.

4. *Lack of flexibility*: Hard-coded passwords limit the flexibility of the software and increase the difficulty to integrate with other systems or change the authentication mechanism.

# How Can I Resolve This?

It is recommended to store passwords separately from the program code
using secure and encrypted methods such as key management systems or password managers.

# Examples
## Non-Compliant

```java
String authToken = "aH-3jxLE4q2vLtGrmywTUu4ZVsGFjwURe9G";
```

## Compliant

```java
String authToken = System.getenv("AUTH_TOKEN");
```