``` python
class BaseForm(object):
    pass

class FormType(type):
    pass
```
  
``` python
# Python 2 only:
class Form(BaseForm):
    __metaclass__ = FormType
    pass
```
  
``` python
# Python 3 only:
class Form(BaseForm, metaclass=FormType):
    pass
```
  
``` python
# Python 2 and 3:
from six import with_metaclass
# or
from future.utils import with_metaclass

class Form(with_metaclass(FormType, BaseForm)):
    pass
```

See also [Cheat Sheet: Writing Python 2-3 compatible code](http://python-future.org/compatible_idioms.html)

[Copyright (c) 2013-2016 Python Charmers Pty Ltd, Australia](https://github.com/PythonCharmers/python-future/blob/master/LICENSE.txt)