Ensuring method pairs are called together can prevent issues of incomplete or inconsistent state management.
Review your code to ensure that if a method from a designated pair is called, its counterpart is called as well.

# What Does This Check Look For?

This check identifies instances where, in a pair of methods that should be called together, one is called without the other in the same class context.

# Why is This a Problem?

Using method pairs correctly is crucial for maintaining state, ensuring proper cleanup, or keeping objects in a valid state. Failing to call both methods of a pair can lead to resource leaks, incomplete transactions, or inconsistent states within the application. This is especially true in resources management, such as opening and closing connections or starting and stopping services, where the failure to complete both actions can lead to significant issues.

# How Can I Resolve This?

To resolve this issue, review the logic of your class to ensure that whenever one method of the pair is called, the counterpart is also called within the same execution flow. This might involve adding the missing method call or restructuring your logic to ensure both methods are included where necessary.

# Examples

## Non-Compliant

```java
class ResourceUsage {
	void useResource() {
		startResource();
		// ...
		// missing stopResource() call
	}
}
```

## Compliant

```java
class ResourceUsage {
	void useResource() {
		startResource();
		// ...
		stopResource();
	}
}
```
