Unannotated public methods in JUnit test classes might unintentionally be overlooked by JUnit.
Consider adding an appropriate JUnit annotation or modifying the method's access modifier.

# What Does This Check Look For?

This check identifies public methods within JUnit 4 or 5 test classes that lack JUnit-specific annotations.
These methods are crucial for defining the test lifecycle or behavior but are missing annotations like `@Test`, `@BeforeEach`, `@After`, `@Rule`, `@Override`, `@RepeatedTest`, or `@ParameterizedTest` that are necessary for JUnit to recognize and handle them properly.

# Why is This a Problem?

Without the proper annotations, JUnit may not execute some tests, or it might miss initial setup and final teardown operations, leading to misleading test outcomes.
This could potentially mask bugs or lead to a misunderstanding of code coverage, reducing the effectiveness of the tests and possibly allowing bugs to go unnoticed.

# How Can I Resolve This?

Review the method to determine its intended role within the test class.
If the method is meant to define a test, a setup step, a teardown step, or a specialized testing operation, annotate it appropriately with `@Test`, `@BeforeEach`, `@After`, `@Rule`, `@RepeatedTest`, or `@ParameterizedTest`.
If the method should not be exposed as part of the test lifecycle, consider changing its access modifier to `private` or `protected`.

# Examples

## Non-Compliant

```java
public class ExampleTest {
    public void testMethod() { // non-compliant: missing @Test annotation
        // test code
    }
}
```

## Compliant

```java
public class ExampleTest {
    @Test
    public void testMethod() { // compliant: annotated with @Test
        // test code
    }
}
```
