This check detects files which contain Objective-C code but do not use one of the file extensions expected for this language.
For example, a file with a `.c` file extension instead of `.m`.
The concrete extensions that are expected can be configured.

Note that this check is applied _before_ any preprocessing.

# Why is this a problem?

Especially in heterogeneous code bases, libraries may provide interfaces in several languages.
Not properly differentiating files by their extension can cause the wrong files to be included.
Regardless, explicit differentiation of files written in different languages simplifies programming tasks, such as browsing the repository for relevant files. 

This check can also be useful when transitioning a code base from one language to the other (_e.g._ from C++ to Objective-C).
