Octal constants can easily be misinterpreted as decimal constants.
Use decimal or hexadecimal format to avoid confusion.

# What Does This Check Look For?

This check detects any use of octal constants as integer literals except the special case 0.

# Why is This a Problem?

Octal constants can easily be misinterpreted as decimal constants.

## Exceptions

One typical use for octal constants are file system permissions.
While some guidelines (like MISRA) forbid using them under all circumstances, using them in the case of file system permissions can make sense.
They are the de-facto standard and the danger of confusion should be pretty low from the context alone.

However, wherever possible we still recommend using the language appropriate mechanism over octal constants. 
For example, for C use the posix macros defined in `sys/stat.h` such as `S_IRGRP` or `S_IWUSR`.

# How Can I Resolve This?

Use decimal or hexadecimal format to avoid confusion.
For file system permissions consider using the appropriate language mechanism such as pre-defined macros.

# Examples
## Non-Compliant

```C
uint16_t values[4];

values[0] = 42;         // compliant:     decimal 42
values[1] = 23;         // compliant:     decimal 23
values[2] = 0105;       // non-compliant: decimal 69
values[3] = 02471;      // non-compliant: decimal 1337

// non-compliant
chmod("./temp.file", 0770);
```

## Compliant

```C
uint16_t values[4];

values[0] = 42;         // compliant: decimal 42
values[1] = 23;         // compliant: decimal 23
values[2] = 69;         // compliant: decimal 69
values[3] = 1337;       // compliant: decimal 1337

// compliant: uses relevant macros
#include <sys/stat.h>
chmod("./temp.file", S_IRWXU|S_IRWXG);
```

# Where Can I Learn More?

- Guideline: MISRA C:2012: 7.1 - Octal constants shall not be used