``` python
# Python 2 only:
raise ValueError, "dodgy value"
```
  
``` python
# Python 2 and 3:
raise ValueError("dodgy value")
```
  
Raising exceptions with a traceback:
``` python
# Python 2 only:
traceback = sys.exc_info()[2]
raise ValueError, "dodgy value", traceback
```
  
``` python
# Python 3 only:
raise ValueError("dodgy value").with_traceback()
```
  
``` python
# Python 2 and 3: option 1
from six import reraise as raise_
# or
from future.utils import raise_

traceback = sys.exc_info()[2]
raise_(ValueError, "dodgy value", traceback)
```
  
``` python
# Python 2 and 3: option 2
from future.utils import raise_with_traceback

raise_with_traceback(ValueError("dodgy value"))
```
  
Exception chaining (PEP 3134):
``` python
# Setup:
class DatabaseError(Exception):
    pass
```
  
``` python
# Python 3 only
class FileDatabase:
    def __init__(self, filename):
        try:
            self.file = open(filename)
        except IOError as exc:
            raise DatabaseError('failed to open') from exc
```
  
``` python
# Python 2 and 3:
from future.utils import raise_from

class FileDatabase:
    def __init__(self, filename):
        try:
            self.file = open(filename)
        except IOError as exc:
            raise_from(DatabaseError('failed to open'), exc)
```
  
``` python
# Testing the above:
try:
    fd = FileDatabase('non_existent_file.txt')
except Exception as e:
    assert isinstance(e.__cause__, IOError)# FileNotFoundError on Py3.3+ inherits from IOError
```
  

See also [Cheat Sheet: Writing Python 2-3 compatible code](http://python-future.org/compatible_idioms.html)

[Copyright (c) 2013-2016 Python Charmers Pty Ltd, Australia](https://github.com/PythonCharmers/python-future/blob/master/LICENSE.txt)