Using explicit types for lambda parameters can make the code more verbose than necessary. Prefer using type inference with lambdas for brevity and readability.

# What Does This Check Look For?

This check identifies lambdas that explicitly declare the type of their parameters, where type inference could be used instead.

# Why is This a Problem?

Explicit type declarations in lambda parameters increase verbosity without adding clarity, making the code harder to read and understand at a glance. It goes against modern Java practices which encourage the use of type inference to make the code concise and maintainable. Additionally, in contexts where the lambda's signature is clear from the context, explicitly typed parameters are redundant.

# How Can I Resolve This?

Consider using type inference by omitting the type for lambda parameters to make the code cleaner and more readable. If a lambda becomes complex enough to warrant explicit types for clarity, it might be a sign that the lambda should be refactored into a named method.

# Examples

## Non-Compliant

```java
public class Main {
	public static void main(String[] args) {
		List<String> names = Arrays.asList("Alice", "Bob", "Charlie", "David");
		Collections.sort(names, (String a, String b) -> a.compareTo(b));
	}
}
```

## Compliant

```java
public class Main {
	public static void main(String[] args) {
		List<String> names = Arrays.asList("Alice", "Bob", "Charlie", "David");
		Collections.sort(names, (a, b) -> a.compareTo(b));
	}
}
```

