When using classic initialization mode, Merge blocks shall adhere to certain specifications and settings to ensure consistency and avoid unexpected behavior.
This also helps migrating models to simplified initialization mode.

This check implements the following subchecks:

- Subcheck 1: The option "Detect multiple driving blocks executing at the same time" shall be set to "error".
- Subcheck 5: An explicit value shall be specified for the "Initial output" parameter of root Merge blocks.
- Subcheck 6: Merge blocks shall not have nonzero input port offsets.
- Subcechk 7: Merge blocks shall not have unconnected inputs or inputs from non-conditionally executed subsystems.
- Subcheck 9: Merge blocks shall not have inconsistent input sample times.
    Note that this check is only recursively evaluated within the same model.
- Subcheck 10: Merge blocks shall not have multiple input ports that are driven by a single source.

The remaining subchecks are not implemented.

## References

- Corresponding Model Advisor check [mathworks.design.MergeBlkUsage](https://mathworks.com/help/simulink/slref/simulink-checks_bq6d4aa-1.html#MATitleCheckForProperMergeBlockUsage)
