/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.cache;

import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;

public class CacheEntry {
    private final byte[] response;
    private final int expires;
    private final long timestamp = System.currentTimeMillis();
    private final MultivaluedMap<String, Object> headers;
    private final MultivaluedMap<String, String> varyHeaders;
    private final EntityTag etag;

    public CacheEntry(MultivaluedMap<String, Object> headers, byte[] response, int expires, EntityTag etag, MultivaluedMap<String, String> varyHeaders) {
        this.headers = new MultivaluedHashMap(headers);
        this.response = response;
        this.expires = expires;
        this.etag = etag;
        this.varyHeaders = new MultivaluedHashMap(varyHeaders);
    }

    public int getExpirationInSeconds() {
        return this.expires - (int)((System.currentTimeMillis() - this.timestamp) / 1000L);
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.timestamp >= (long)(this.expires * 1000);
    }

    public EntityTag getEtag() {
        return this.etag;
    }

    public byte[] getResponse() {
        return this.response;
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return this.headers;
    }

    public MultivaluedMap<String, String> getVaryHeaders() {
        return this.varyHeaders;
    }
}

