/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.provider;

import com.fasterxml.jackson.databind.JsonNode;
import com.teamscale.service.framework.impl.provider.FunctionalConverter;
import com.teamscale.service.framework.impl.provider.InvalidValueException;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;

@Provider
public class JsonNodeConverterProvider
implements ParamConverterProvider {
    public <P> ParamConverter<P> getConverter(Class<P> rawType, Type genericType, Annotation[] annotations) {
        if (rawType.isAssignableFrom(JsonNode.class)) {
            return new FunctionalConverter(annotations, JsonNodeConverterProvider::convert);
        }
        return null;
    }

    private static JsonNode convert(String json) throws InvalidValueException {
        try {
            return JsonUtils.deserializeFromJson((String)json);
        }
        catch (JsonSerializationException e) {
            throw new InvalidValueException("Unable to parse JSON string", e);
        }
    }
}

