/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import org.conqat.lib.commons.collections.UnmodifiableIterator;
import org.conqat.lib.commons.collections.UnmodifiableNavigableSet;
import org.conqat.lib.commons.collections.UnmodifiableSortedSet;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class UnmodifiableNavigableSetImpl<E>
implements UnmodifiableNavigableSet<E> {
    private static final long serialVersionUID = 1L;
    private final NavigableSet<E> navigableSet;

    public UnmodifiableNavigableSetImpl(NavigableSet<E> navigableSet) {
        this.navigableSet = Collections.unmodifiableNavigableSet(navigableSet);
    }

    @Override
    public UnmodifiableNavigableSet<E> reversed() {
        return UnmodifiableNavigableSet.of(this.navigableSet.reversed());
    }

    @Override
    public @NonNull UnmodifiableNavigableSet<E> descendingSet() {
        return UnmodifiableNavigableSet.of(this.navigableSet.descendingSet());
    }

    @Override
    public @NonNull UnmodifiableIterator<E> descendingIterator() {
        return UnmodifiableIterator.of(this.navigableSet.descendingIterator());
    }

    @Override
    public @NonNull UnmodifiableNavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return UnmodifiableNavigableSet.of(this.navigableSet.subSet(fromElement, fromInclusive, toElement, toInclusive));
    }

    @Override
    public @NonNull UnmodifiableNavigableSet<E> headSet(E toElement, boolean inclusive) {
        return UnmodifiableNavigableSet.of(this.navigableSet.headSet(toElement, inclusive));
    }

    @Override
    public @NonNull UnmodifiableNavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return UnmodifiableNavigableSet.of(this.navigableSet.tailSet(fromElement, inclusive));
    }

    @Override
    public @Nullable E lower(E e) {
        return this.navigableSet.lower(e);
    }

    @Override
    public @Nullable E floor(E e) {
        return this.navigableSet.floor(e);
    }

    @Override
    public @Nullable E ceiling(E e) {
        return this.navigableSet.ceiling(e);
    }

    @Override
    public @Nullable E higher(E e) {
        return this.navigableSet.higher(e);
    }

    @Override
    public @NonNull UnmodifiableSortedSet<E> subSet(E fromElement, E toElement) {
        return UnmodifiableSortedSet.of(this.navigableSet.subSet(fromElement, toElement));
    }

    @Override
    public @NonNull UnmodifiableSortedSet<E> headSet(E toElement) {
        return UnmodifiableSortedSet.of(this.navigableSet.headSet(toElement));
    }

    @Override
    public @NonNull UnmodifiableSortedSet<E> tailSet(E fromElement) {
        return UnmodifiableSortedSet.of(this.navigableSet.tailSet(fromElement));
    }

    @Override
    public @Nullable Comparator<? super E> comparator() {
        return this.navigableSet.comparator();
    }

    @Override
    public E first() {
        return this.navigableSet.first();
    }

    @Override
    public E last() {
        return this.navigableSet.last();
    }

    @Override
    public int size() {
        return this.navigableSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.navigableSet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.navigableSet.contains(o);
    }

    @Override
    public Object @NonNull [] toArray() {
        return this.navigableSet.toArray();
    }

    @Override
    public <T> T @NonNull [] toArray(T @NonNull [] a) {
        return this.navigableSet.toArray(a);
    }

    @Override
    public boolean containsAll(@NonNull Collection<?> c) {
        return this.navigableSet.containsAll(c);
    }

    @Override
    public @NonNull UnmodifiableIterator<E> iterator() {
        return UnmodifiableIterator.of(this.navigableSet.iterator());
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.navigableSet.spliterator();
    }

    @Override
    public E getFirst() {
        return this.navigableSet.getFirst();
    }

    @Override
    public E getLast() {
        return this.navigableSet.getLast();
    }

    @Override
    public <T> T[] toArray(IntFunction<T[]> generator) {
        return this.navigableSet.toArray(generator);
    }

    @Override
    public Stream<E> stream() {
        return this.navigableSet.stream();
    }

    @Override
    public Stream<E> parallelStream() {
        return this.navigableSet.parallelStream();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.navigableSet.forEach(action);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UnmodifiableNavigableSetImpl) {
            UnmodifiableNavigableSetImpl that = (UnmodifiableNavigableSetImpl)o;
            return this.navigableSet.equals(that.navigableSet);
        }
        return this.navigableSet.equals(o);
    }

    @Override
    public int hashCode() {
        return this.navigableSet.hashCode();
    }

    public String toString() {
        return this.navigableSet.toString();
    }
}

