/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.diff;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.algo.Diff;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.diff.DiffDescription;
import org.conqat.lib.commons.diff.TextChunk;

public abstract class DifferBase<T> {
    private static final int MAX_DIFF_SIZE = 10000;
    private static final Pattern FRAGMENT_MATCH_PATTERN = Pattern.compile("@\\p{Alpha}+|\\w+|\\d+|\\s+|.");
    private String leftText;
    private String rightText;
    private List<TextChunk> leftChunks;
    private List<TextChunk> rightChunks;

    public DiffDescription performDiff(T leftElement, T rightElement) {
        this.leftText = this.getElementText(leftElement);
        this.rightText = this.getElementText(rightElement);
        this.leftChunks = this.getChunks(leftElement, true);
        this.rightChunks = this.getChunks(rightElement, false);
        Diff.Delta<TextChunk> delta = Diff.computeDelta(this.leftChunks, this.rightChunks, 10000);
        DiffDescription diffDescription = new DiffDescription(this.getDiffName());
        this.convertDiffToDiffDescription(delta, diffDescription);
        return this.postProcessDiffDescription(diffDescription);
    }

    protected DiffDescription postProcessDiffDescription(DiffDescription diffDescription) {
        return diffDescription;
    }

    protected abstract String getElementText(T var1);

    private void convertDiffToDiffDescription(Diff.Delta<TextChunk> delta, DiffDescription diffDescription) {
        boolean[] chunkRemoved = new boolean[this.leftChunks.size()];
        boolean[] chunkAdded = new boolean[this.rightChunks.size()];
        for (int i = 0; i < delta.getSize(); ++i) {
            int position = delta.getPosition(i);
            if (position < 0) {
                chunkRemoved[-position - 1] = true;
                continue;
            }
            chunkAdded[position - 1] = true;
        }
        int leftChunkPosition = 0;
        int rightChunkPosition = 0;
        while (leftChunkPosition < chunkRemoved.length || rightChunkPosition < chunkAdded.length) {
            int removedChunksRegionStart = leftChunkPosition;
            int addedChunksRegionStart = rightChunkPosition;
            while (leftChunkPosition < chunkRemoved.length && chunkRemoved[leftChunkPosition]) {
                ++leftChunkPosition;
            }
            while (rightChunkPosition < chunkAdded.length && chunkAdded[rightChunkPosition]) {
                ++rightChunkPosition;
            }
            if (removedChunksRegionStart != leftChunkPosition || addedChunksRegionStart != rightChunkPosition) {
                this.insertDiffRegion(diffDescription, removedChunksRegionStart, leftChunkPosition, addedChunksRegionStart, rightChunkPosition);
                continue;
            }
            ++leftChunkPosition;
            ++rightChunkPosition;
        }
    }

    private void insertDiffRegion(DiffDescription diffDescription, int currentLeftStart, int currentLeftEnd, int currentRightStart, int currentRightEnd) {
        Pair<Integer, Integer> leftLines = DifferBase.convertToFirstLastLine(currentLeftStart, currentLeftEnd, this.leftChunks);
        Pair<Integer, Integer> rightLines = DifferBase.convertToFirstLastLine(currentRightStart, currentRightEnd, this.rightChunks);
        diffDescription.addLineRegion((Integer)leftLines.getFirst(), (Integer)leftLines.getSecond(), (Integer)rightLines.getFirst(), (Integer)rightLines.getSecond());
        List<TextChunk> leftFragments = DifferBase.extractFragments(currentLeftStart, currentLeftEnd, this.leftText, this.leftChunks);
        List<TextChunk> rightFragments = DifferBase.extractFragments(currentRightStart, currentRightEnd, this.rightText, this.rightChunks);
        Diff.Delta<TextChunk> delta = Diff.computeDelta(leftFragments, rightFragments, 10000);
        for (int i = 0; i < delta.getSize(); ++i) {
            TextChunk fragment;
            int position = delta.getPosition(i);
            if (position > 0) {
                fragment = rightFragments.get(position - 1);
                diffDescription.addRightChange(fragment.startOffset, fragment.endOffset);
                continue;
            }
            fragment = leftFragments.get(-position - 1);
            diffDescription.addLeftChange(fragment.startOffset, fragment.endOffset);
        }
    }

    private static Pair<Integer, Integer> convertToFirstLastLine(int startIndex, int endIndex, List<TextChunk> units) {
        if (units.isEmpty() || endIndex == 0) {
            return new Pair<Integer, Integer>(1, 1);
        }
        int firstLine = startIndex >= units.size() ? units.get((int)(startIndex - 1)).endLine : units.get((int)startIndex).startLine;
        int lastLine = Math.max(firstLine, units.get((int)(endIndex - 1)).endLine);
        return new Pair<Integer, Integer>(firstLine, lastLine);
    }

    private static List<TextChunk> extractFragments(int startIndex, int endIndex, String text, List<TextChunk> units) {
        if (startIndex >= units.size() || startIndex >= endIndex) {
            return CollectionUtils.emptyList();
        }
        ArrayList<TextChunk> fragments = new ArrayList<TextChunk>();
        int startOffset = units.get((int)startIndex).startOffset;
        int endOffset = Math.min(units.get((int)(endIndex - 1)).endOffset, text.length());
        Matcher matcher = FRAGMENT_MATCH_PATTERN.matcher(text.substring(startOffset, endOffset));
        while (matcher.find()) {
            int fragmentStart = startOffset + matcher.start();
            String fragmentText = matcher.group();
            if (fragmentText.contains("\n")) continue;
            fragments.add(new TextChunk(fragmentStart, fragmentStart + fragmentText.length(), 0, 0, fragmentText));
        }
        return fragments;
    }

    protected abstract List<TextChunk> getChunks(T var1, boolean var2);

    protected abstract String getDiffName();
}

